<p align="center">
  <a href="https://eazymizy.com"><img src="https://eazymizy.com/assets/media/images/miz-framework-banner.png" alt="MIZ Banner" width="100%"></a>
</p>

<h1 align="center" style="color:#89001A;"><a href="https://eazymizy.com">MIZ CSS Framework</a></h1>
<p align="center"><strong>Speed meets Strength in web design, with MIZ</strong></p>

<p align="center">
  <a href="https://www.npmjs.com/package/miz-59"><img src="https://img.shields.io/npm/v/miz-59?color=%2389001A&label=npm" alt="npm version"></a>
  <a href="https://eazymizy.com/docs/about/license"><img src="https://img.shields.io/badge/License-MIT-%2389001A" alt="MIT License"></a>
  <a href="https://github.com/miz59/miz/stargazers"><img src="https://img.shields.io/github/stars/eazymizy/miz?style=social" alt="GitHub stars"></a>
</p>

## 📌 Introduction

MIZ is a **powerful frontend CSS framework** built with **Sass**, designed to give developers **speed and full control** over their projects.  

It combines:  
- a **page builder (Mizban)** 🏗️  
- **css cleaner base on used classes** 🎈
- a **component library (Mizoon)** 🧩  
- **custom theme creation** 🎨  
- **structured design & full Sass-based customization** ⚡

MIZ is **open-source**, lightweight, and fully **customizable**, allowing you to create **efficient and maintainable front-end projects**.

## 🛠 Features

| Feature | Description |
|---------|-------------|
| 🏗️ Mizban Page Builder | Visual page builder for fast prototyping |
| 🎈 Css Cleaner | Clean unused classes from output css |
| 🧩 Mizoon Components | Reusable UI components library |
| ⚡ Sass-based framework | Fully Sass-based, flexible, and customizable |
| 🎨 Customizable themes | Create your own themes easily |
| 🚀 Lightweight & optimized | Fast, minimal, and efficient CSS output |
| 🌍 Open-source | Community-driven and MIT licensed |

## 📘 Documentation

Whether you're a beginner or expert, MIZ offers clear and practical documentation to guide you through installation, structure, and customization.  

Explore the docs to start building with MIZ:  
👉 [**Get Started with MIZ**](https://eazymizy.com/docs/get-started/install)

You’ll find detailed guides on:

- [**Framework setup & usage**](https://eazymizy.com/docs/get-started/install)  
- [**Mizoon components**](https://eazymizy.com/docs/components/accordion)  
- [**Mizban page builder**](https://eazymizy.com/mizban-studio)  
- [**Theme customization and structure**](https://eazymizy.com/docs/customize/color)

## 🧩 Components & Page Builder

MIZ includes:

- **Mizoon Components**: Reusable UI elements for faster development. [Learn more](https://eazymizy.com/docs/components/accordion)  
- **Mizban Page Builder**: Visual page builder for fast prototyping and structured design. [Learn more](https://eazymizy.com/mizban-studio)

## 🧾 Changelog

Stay updated with the latest improvements, features, and fixes via the [MIZ Changelog](https://eazymizy.com/changelog).

## 🤝 About FAP Group

With the motto **"Don't start from zero"**, the **FAP group** set out to build a front-end framework called **MIZ** —  
making front-end development more **enjoyable**, **structured**, and **simple**.  

Help us in the challenging journey of **simplification** 🙂

## 🌐 Connect & Follow

Follow us for updates, news, and demos:  
[X](#) | [Linkedin](https://www.linkedin.com/company/miz59/‏) | [YouTube](#) | [GitHub](https://github.com/miz59/miz) | [Npm](https://www.npmjs.com/package/miz-59)

Visit our official website: [**eazymizy.com**](https://eazymizy.com)

## 📄 License

MIZ is released under the **MIT License**.  
[View license](https://eazymizy.com/docs/about/license)
